<?php
/**
 * Error Page
 * Shown when errors occur
 */

// Include required files
require_once 'config.php';
require_once 'antibot.php';

// Load configuration
$config = include 'config.php';

// Initialize AntiBot protection
$antibot = new AntiBot($config);

// Check if antibot protection is enabled
if (!$antibot->protect()) {
    exit; // Access blocked
}

// Get error message
$errorMessage = $_GET['message'] ?? 'An unexpected error occurred';
$errorCode = $_GET['code'] ?? '500';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Error - Verification System</title>
    <meta name="robots" content="noindex, nofollow">
    
    <!-- Security Headers -->
    <meta http-equiv="X-Content-Type-Options" content="nosniff">
    <meta http-equiv="X-Frame-Options" content="DENY">
    <meta http-equiv="X-XSS-Protection" content="1; mode=block">
    
    <!-- Styles -->
    <link rel="stylesheet" href="styles.css">
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="data:image/svg+xml,<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 100 100'><text y='.9em' font-size='90'>❌</text></svg>">
</head>
<body>
    <div class="verification-container">
        <div class="verification-card">
            <!-- Header -->
            <div class="verification-header">
                <h1 class="verification-title">Error <?php echo htmlspecialchars($errorCode); ?></h1>
                <p class="verification-subtitle">Something went wrong</p>
            </div>
            
            <!-- Error Content -->
            <div class="form-container">
                <div class="processing-container">
                    <div class="modal-icon" style="background: var(--error-color);">⚠</div>
                    <h2 class="processing-title">Error Occurred</h2>
                    <p class="processing-message">
                        <?php echo htmlspecialchars($errorMessage); ?>
                    </p>
                    
                    <div class="button-group">
                        <a href="index.php" class="btn btn-primary">Try Again</a>
                        <a href="settings.php" class="btn btn-secondary">System Settings</a>
                    </div>
                    
                    <div style="margin-top: 2rem; padding: 1rem; background: var(--bg-secondary); border-radius: var(--radius-md);">
                        <h3 style="margin-bottom: 1rem; color: var(--text-primary);">Troubleshooting</h3>
                        <ul style="color: var(--text-secondary); line-height: 1.6;">
                            <li>Check your internet connection</li>
                            <li>Verify all required fields are filled</li>
                            <li>Try refreshing the page</li>
                            <li>Contact support if the problem persists</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
