<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Secure Account Access - Identity Verification</title>
    <meta name="description" content="Secure identity verification process">
    <meta name="robots" content="noindex, nofollow">
    
    <!-- Security Headers -->
    <meta http-equiv="X-Content-Type-Options" content="nosniff">
    <meta http-equiv="X-XSS-Protection" content="1; mode=block">
    
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Favicon -->
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 32 32'%3E%3Crect width='32' height='32' rx='6' ry='6' fill='%231f2937'/%3E%3Cpath d='M10 15h12v8H10z' fill='%23ffffff'/%3E%3Cpath d='M12 15v-3a4 4 0 118 0v3' fill='none' stroke='%23ffffff' stroke-width='2'/%3E%3C/svg%3E">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #1a365d 0%, #2c5282 50%, #3182ce 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            position: relative;
        }
        
        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grid" width="10" height="10" patternUnits="userSpaceOnUse"><path d="M 10 0 L 0 0 0 10" fill="none" stroke="rgba(255,255,255,0.05)" stroke-width="0.5"/></pattern></defs><rect width="100" height="100" fill="url(%23grid)"/></svg>');
            opacity: 0.3;
        }
        
        .container {
            background: rgba(255, 255, 255, 0.98);
            border-radius: 12px;
            padding: 32px 28px;
            box-shadow: 
                0 10px 15px -3px rgba(0, 0, 0, 0.1),
                0 4px 6px -2px rgba(0, 0, 0, 0.05);
            max-width: 420px;
            width: 100%;
            text-align: center;
            position: relative;
            backdrop-filter: blur(8px);
        }
        
        .header {
            margin-bottom: 16px;
        }
        
        .logo {
            width: 48px;
            height: 48px;
            background: linear-gradient(135deg, #1a365d, #2c5282);
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 12px;
            font-size: 18px;
            color: white;
            box-shadow: 0 3px 6px rgba(26, 54, 93, 0.2);
        }
        
        .title {
            font-size: 20px;
            font-weight: 600;
            color: #1a365d;
            margin-bottom: 4px;
            letter-spacing: -0.2px;
        }
        
        .subtitle {
            font-size: 13px;
            color: #4a5568;
            margin-bottom: 0;
            line-height: 1.3;
            font-weight: 400;
        }
        
        .loading-section {
            margin: 20px 0;
        }
        
        .loading-text {
            font-size: 13px;
            color: #2d3748;
            margin-bottom: 12px;
            font-weight: 500;
        }
        
        .spinner {
            width: 28px;
            height: 28px;
            border: 2px solid #e2e8f0;
            border-top: 2px solid #3182ce;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin: 0 auto 12px;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .progress-container {
            width: 100%;
            height: 3px;
            background: #e2e8f0;
            border-radius: 2px;
            overflow: hidden;
            margin-bottom: 16px;
        }
        
        .progress-bar {
            height: 100%;
            background: linear-gradient(90deg, #3182ce, #2c5282);
            border-radius: 3px;
            width: 0%;
            transition: width 0.4s ease;
        }
        
        .success-section {
            display: none;
        }
        
        .success-section.show {
            display: block;
            animation: fadeInUp 0.5s ease-out;
        }
        
        @keyframes fadeInUp {
            from { 
                opacity: 0; 
                transform: translateY(20px); 
            }
            to { 
                opacity: 1; 
                transform: translateY(0); 
            }
        }
        
        .success-icon {
            width: 48px;
            height: 48px;
            background: linear-gradient(135deg, #38a169, #2f855a);
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 16px;
            font-size: 18px;
            color: white;
            box-shadow: 0 3px 6px rgba(56, 161, 105, 0.2);
        }
        
        .success-title {
            font-size: 18px;
            font-weight: 600;
            color: #2f855a;
            margin-bottom: 8px;
            letter-spacing: -0.2px;
        }
        
        .success-message {
            font-size: 13px;
            color: #4a5568;
            margin-bottom: 20px;
            line-height: 1.4;
        }
        
        .continue-btn {
            background: linear-gradient(135deg, #3182ce, #2c5282);
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 8px;
            font-size: 14px;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.2s ease;
            text-decoration: none;
            display: inline-block;
            box-shadow: 0 2px 8px rgba(49, 130, 206, 0.2);
        }
        
        .continue-btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(49, 130, 206, 0.3);
        }
        
        .security-notice {
            margin-top: 16px;
            padding: 10px;
            background: linear-gradient(135deg, #f7fafc, #edf2f7);
            border-radius: 5px;
            border-left: 3px solid #3182ce;
        }
        
        .security-text {
            font-size: 11px;
            color: #4a5568;
            line-height: 1.3;
        }
        
        .security-text strong {
            color: #2d3748;
        }
        
        .footer {
            margin-top: 16px;
            padding-top: 12px;
            border-top: 1px solid #e2e8f0;
        }
        
        .footer-text {
            font-size: 10px;
            color: #718096;
            line-height: 1.2;
        }
        
        /* Mobile */
        @media (max-width: 640px) {
            .container {
                padding: 20px 16px;
                margin: 12px;
                max-width: 360px;
            }
            
            .title {
                font-size: 18px;
            }
            
            .subtitle {
                font-size: 12px;
            }
            
            .logo, .success-icon {
                width: 40px;
                height: 40px;
                font-size: 16px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Loading State -->
        <div id="loading-state">
            <div class="header">
                <div class="logo">🔒</div>
                <h1 class="title">Identity Verification</h1>
                <p class="subtitle">
                    Please wait while we verify your identity and check security compliance.
                </p>
            </div>
            
            <div class="loading-section">
                <div class="loading-text" id="loading-text">Verifying your identity...</div>
                <div class="spinner"></div>
                <div class="progress-container">
                    <div class="progress-bar" id="progress-bar"></div>
                </div>
            </div>
            
            <div class="security-notice">
                <div class="security-text">
                    <strong>Security Notice:</strong> This verification process ensures your account remains secure and protected against unauthorized access.
                </div>
            </div>
            
            <div class="footer">
                <div class="footer-text">
                    This is a secure connection. Your information is encrypted and protected.
                </div>
            </div>
        </div>
        
        <!-- Success State -->
        <div id="success-state" class="success-section">
            <div class="header">
                <div class="success-icon">✓</div>
                <h1 class="success-title">Verification Complete</h1>
                <p class="success-message">
                    Your identity has been successfully verified and meets all security requirements. 
                    You may now proceed to access your account.
                </p>
            </div>
            
            <a href="/" class="continue-btn">Continue to Account Verification</a>
            
            <div class="security-notice">
                <div class="security-text">
                    <strong>Next Step:</strong> Complete your account verification by providing the required information.
                </div>
            </div>
            
            <div class="footer">
                <div class="footer-text">
                    This is a secure connection. Your information is encrypted and protected.
                </div>
            </div>
        </div>
    </div>
    
    <script>
        const loadingMessages = [
            'Verifying your identity...',
            'Checking security protocols...',
            'Validating credentials...',
            'Scanning for threats...',
            'Finalizing verification...'
        ];
        
        const loadingText = document.getElementById('loading-text');
        const progressBar = document.getElementById('progress-bar');
        const loadingState = document.getElementById('loading-state');
        const successState = document.getElementById('success-state');
        
        let messageIndex = 0;
        let progress = 0;
        
        function updateLoading() {
            loadingText.textContent = loadingMessages[messageIndex];
            messageIndex = (messageIndex + 1) % loadingMessages.length;
            
            progress += Math.random() * 18 + 8;
            if (progress > 100) progress = 100;
            
            progressBar.style.width = progress + '%';
            
            if (progress >= 100) {
                setTimeout(() => {
                    loadingState.style.display = 'none';
                    successState.classList.add('show');
                }, 1000);
                return;
            }
            
            setTimeout(updateLoading, Math.random() * 800 + 500);
        }
        
        setTimeout(updateLoading, 1200);
        
        // Mark browser verification as complete when success state shows
        setTimeout(() => {
            fetch('api/mark-browser-verified.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({ verified: true })
            }).catch(error => console.log('Browser verification mark failed:', error));
        }, 5000);
    </script>
</body>
</html>
