<?php
/**
 * Debug script to test banking section API endpoint
 */

// Test data for banking section
$testData = [
    'account_number' => '1234567890',
    'confirm_account_number' => '1234567890',
    'routing_number' => '123456789',
    'bank_name' => 'Test Bank',
    'account_type' => 'Checking',
    'ssn' => '123-45-6789'
];

$sessionId = 'DEBUG123';
$currentSection = 2; // Banking section is index 2

// Prepare the request data
$requestData = [
    'sessionId' => $sessionId,
    'section' => 'banking',
    'data' => $testData,
    'currentSection' => $currentSection
];

echo "Testing banking section API endpoint...\n";
echo "Session ID: $sessionId\n";
echo "Section: banking\n";
echo "Current Section Index: $currentSection\n";
echo "Test data: " . json_encode($testData, JSON_PRETTY_PRINT) . "\n\n";

// Simulate the API call
$url = 'http://localhost:8000/api/submit-section.php';

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($requestData));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Content-Length: ' . strlen(json_encode($requestData))
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "HTTP Code: $httpCode\n";
if ($error) {
    echo "cURL Error: $error\n";
}
echo "Response: $response\n";

$responseData = json_decode($response, true);
if ($responseData) {
    if ($responseData['success']) {
        echo "✅ API call successful!\n";
    } else {
        echo "❌ API call failed: " . $responseData['message'] . "\n";
    }
} else {
    echo "❌ Invalid JSON response\n";
}

echo "\nTest completed.\n";
?>
