<?php
/**
 * Mark Browser Verification Complete API
 * Marks browser verification as completed in session
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

// Start session
session_start();

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);

if (!$input || !isset($input['verified'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Invalid input']);
    exit;
}

// Mark browser verification as complete
$_SESSION['browser_verified'] = true;
$_SESSION['browser_verified_at'] = time();

// Return success response
echo json_encode([
    'success' => true,
    'message' => 'Browser verification marked as complete'
]);
?>
